

#pragma once

#include "ISourceControlRevision.h"
#include "Ark_Plugin.h"

class FArkSourceControlRevision : public ISourceControlRevision
{
public:

	FArkSourceControlRevision(const FString& in_absolute_path, const Ark_PLugin_File_Revision& file_revision, int32 in_revision_number);
	virtual ~FArkSourceControlRevision() = default;

	// ISourceControlRevision
	virtual bool Get( FString& InOutFilename, EConcurrency::Type InConcurrency = EConcurrency::Synchronous) const override;
	virtual bool GetAnnotated( TArray<FAnnotationLine>& OutLines ) const override;
	virtual bool GetAnnotated( FString& InOutFilename ) const override;
	virtual const FString& GetFilename() const override {
		return absolute_path;
	}
	virtual int32 GetRevisionNumber() const override {
		return revision_number;
	}
	virtual const FString& GetRevision() const override {
		return revision;
	}
	virtual const FString& GetDescription() const override {
		return description;
	}
	virtual const FString& GetUserName() const override {
		return username;
	}
	virtual const FString& GetClientSpec() const override {
		return client_spec;
	}
	virtual const FString& GetAction() const override {
		return action;
	}
	virtual TSharedPtr<ISourceControlRevision, ESPMode::ThreadSafe> GetBranchSource() const override;
	virtual const FDateTime& GetDate() const override {
		return date;
	}
	virtual int32 GetCheckInIdentifier() const override {
		return (int32)cl_id; // Ark is uint32
	}
	virtual int32 GetFileSize() const override {
		return (int32)size; // I guess UE doesn't expect any > 2GB file
	}
	// ~ISourceControlRevision

protected:
	FString absolute_path;
	int64 size = 0;

	int32 revision_number = 0;

	FString revision;
	FString description;
	FString username;
	FString client_spec;
	FString action;

	Ark_Plugin_Time time;

	FDateTime date;

	uint32 cl_id = 0;
	uint32 cl_revision = 0;

	friend class FArkSourceControlState;
};