
#include "FArkSourceControlRevision.h"
#include "Ark_Plugin.h"
#include "ArkSourceControl.h"
#include "ArkSourceControlProvider.h"

FArkSourceControlRevision::FArkSourceControlRevision(const FString& in_absolute_path, const Ark_PLugin_File_Revision& file_revision, int32 in_revision_number) {
	absolute_path = in_absolute_path;
	cl_id = file_revision.cl_id;
	cl_revision = file_revision.cl_revision;
	size = file_revision.size;

	time.low = file_revision.time.low;
	time.high = file_revision.time.high;

	Ark_Plugin_Calendar calendar = ark_plugin_c_time_to_calendar(FArkSourceControlModule::Get().provider.plugin, time);
	date = FDateTime(calendar.year, calendar.month, calendar.day, calendar.hour, calendar.minute, calendar.second, calendar.millisecond);

	revision_number = in_revision_number;

	revision = FString::Printf(TEXT("#%d"), revision_number);
	description = ARK_PLUGIN_STRING_TO_FSTRING(file_revision.cl_comment);
	username = ARK_PLUGIN_STRING_TO_FSTRING(file_revision.user);
	client_spec = ARK_PLUGIN_STRING_TO_FSTRING(file_revision.branch);

	switch (file_revision.file_status) {
		case File_Status_ADD:
			action = TEXT("Added");
			break;
		case File_Status_MOD:
			action = TEXT("Modified");
			break;
		case File_Status_DEL:
			action = TEXT("Deleted");
			break;
		default:
			action = TEXT("");
			break;
	}
}

bool FArkSourceControlRevision::Get( FString& InOutFilename, EConcurrency::Type InConcurrency /*= EConcurrency::Synchronous*/) const {
	auto& provider = FArkSourceControlModule::Get().provider;
	FString relative_path = provider.get_relative_path(absolute_path);
	FString out_temp_absolute_file_path;
	return provider.get_asset(relative_path, cl_id, cl_revision, InOutFilename, InConcurrency);
}

bool FArkSourceControlRevision::GetAnnotated( TArray<FAnnotationLine>& OutLines ) const {
	return false;
}

bool FArkSourceControlRevision::GetAnnotated( FString& InOutFilename ) const {
	return false;
}

TSharedPtr<ISourceControlRevision, ESPMode::ThreadSafe> FArkSourceControlRevision::GetBranchSource() const {
	return nullptr;
}
