﻿#pragma once
#include "ISourceControlChangelist.h"

class FArkSourceControlChangelist : public ISourceControlChangelist
{
public:
	FArkSourceControlChangelist(int64 in_ws_cl_id)
		:ws_cl_id(in_ws_cl_id)
	{
	}
	
	virtual bool CanDelete() const override { return cl_id == 0; }
	virtual FString GetIdentifier() const override { return cl_id == 0 ? "" : FString::Printf(TEXT("%d"), cl_id); }
	virtual bool IsDefault() const override { return is_default; }

	// -1 it's a history cl
	int64 ws_cl_id = -1;

	// 0 it doesn't have a cl id yet, ie local only workspace cl
	uint32 cl_id = 0;

	bool is_default = false;
};
