﻿#pragma once

struct FArkSourceControlSettings
{
	void load_settings();

	void save_settings() const;

	static FString try_to_find_binary_path();

	static FString choose_best_workspace_path();

	FString get_port();

	void set_localhost_with_port(const FString& port);

	// Serialized data
	FString binary_path;
	FString workspace_path;
	FString email;
	FString host;

	bool use_built_in_server = false;
	bool add_default_ignore = false;
	bool add_default_locks = false;


protected:
	mutable FCriticalSection critical_section;
};
