﻿#pragma once
#include "ISourceControlOperation.h"
#include "ISourceControlProvider.h"
#include "Ark_Plugin.h"

struct FArkSourceControlCommandResponse
{
	uint64_t request_id = 0;
	Ark_Plugin_Data data = Ark_Plugin_Data();
};

class FArkSourceControlProvider;

class FArkSourceControlCommand
{
public:
	FArkSourceControlCommand(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files);
	virtual ~FArkSourceControlCommand();

	bool execute();

	void abort();

	virtual void handle_response(Ark_Plugin_Response* response) = 0;

	Ark_Plugin_Array_String get_relative_paths_as_array_string();

	FArkSourceControlProvider& get_provider();
	Ark_Plugin* get_plugin();

	void push_request_id(uint64_t request_id);

	virtual bool can_execute_without_ark_instance() { return false; }

	uint64_t id = 0;

protected:

	virtual bool execute_internal(ECommandResult::Type& out_result) = 0;
	
	FSourceControlOperationRef operation;
	FSourceControlChangelistPtr changelist;
	FSourceControlOperationComplete operation_complete_delegate;
	TArray<FString> relative_paths;
	bool async = false;

	static uint64_t last_id;
};

class FArkSourceControlCommandConnect : public FArkSourceControlCommand
{
public:
	FArkSourceControlCommandConnect(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

	virtual bool can_execute_without_ark_instance() override { return true; }

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool requested_ping = false;
	bool received_ping = false;
	double time_abort_wait_for_ping = 0;
};

class FArkSourceControlCommandUpdateStatus : public FArkSourceControlCommand
{
public:
	FArkSourceControlCommandUpdateStatus(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;
 	
	int32 num_requests_sent = 0;
	int32 num_responses_received = 0;
};

class FArkSourceControlCommandUpdateChangelistsStatus : public FArkSourceControlCommand
{
public:
	FArkSourceControlCommandUpdateChangelistsStatus(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool has_sent_request = false;
	bool has_received_response = false;
};

class FArkSourceControlCommandCheckOut : public FArkSourceControlCommand
{
public:
	FArkSourceControlCommandCheckOut(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool has_sent_request = false;
	bool has_received_response = false;
};

class FArkSourceControlCommandRevert : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandRevert(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool has_sent_request = false;
	bool has_received_response = false;
};

class FArkSourceControlCommandCheckIn : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandCheckIn(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};

class FArkSourceControlCommandNewChangelist : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandNewChangelist(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
};

class FArkSourceControlCommandDeleteChangelist : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandDeleteChangelist(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};

class FArkSourceControlCommandEditChangelist : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandEditChangelist(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};

class FArkSourceControlCommandMoveToChangelist : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandMoveToChangelist(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};

class FArkSourceControlCommandSync : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandSync(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files);

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};


class FArkSourceControlCommandGetFile : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandGetFile(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};

class FArkSourceControlCommandResolve : public FArkSourceControlCommand {
public:
	FArkSourceControlCommandResolve(const FSourceControlOperationRef& in_operation, FSourceControlChangelistPtr in_changelist, const FSourceControlOperationComplete& in_operation_complete_delegate, EConcurrency::Type in_concurrency, const TArray<FString>& in_files)
	:FArkSourceControlCommand(in_operation, in_changelist, in_operation_complete_delegate, in_concurrency, in_files)
	{
	}

	virtual void handle_response(Ark_Plugin_Response* response) override;

protected:
	virtual bool execute_internal(ECommandResult::Type& out_result) override;

	bool sent_request = false;
	bool received_response = false;
	bool success = false;
};
