// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"
#include "ArkSourceControlProvider.h"
#include "ArkSourceControlSettings.h"

#define ARK_PLUGIN_STRING_TO_FSTRING(S) FString::ConstructFromPtrSize((UTF8CHAR *)S.data, S.count)

class FArkSourceControlModule : public IModuleInterface
{
public:
	static FArkSourceControlModule& Get();
	
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

	FArkSourceControlSettings settings;	

	FArkSourceControlProvider provider;
	
};
