// Copyright Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

public class ArkSourceControl : ModuleRules
{
	public ArkSourceControl(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;

		string ark_plugin_directory = ModuleDirectory + "/Ark_Plugin/";
		
		PublicIncludePaths.AddRange(
			new string[] {
			}
			);
				
		
		PrivateIncludePaths.AddRange(
			new string[] {
				ark_plugin_directory
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				"SourceControl",
				"DesktopWidgets",
				"EditorFramework",
				"UnrealEd",
				"Projects",
				"ContentBrowser",
				"ContentBrowserData",
			}
			);
		
		PublicAdditionalLibraries.Add(ark_plugin_directory + "ark_plugin.lib");
		RuntimeDependencies.Add("$(TargetOutputDir)/ark_plugin.dll", ark_plugin_directory + "ark_plugin.dll");
		
		PublicDelayLoadDLLs.Add("ark_plugin.dll");
		
	}
}
