﻿#pragma once

#include "ISourceControlState.h"
#include "Ark_Plugin.h"
#include "ArkSourceControl.h"
#include "FArkSourceControlRevision.h"

class FArkSourceControlState : public ISourceControlState
{
public:
	FArkSourceControlState(const FString& in_file_relative_path)
		:relative_path(in_file_relative_path)
		,file(Ark_Plugin_File())
		,date_time(0)
	{
		absolute_path = FArkSourceControlModule::Get().provider.get_absolute_path(relative_path);
		if (absolute_path.Len() > 0 && absolute_path[absolute_path.Len()-1] == '/') {
			absolute_path.LeftChopInline(1);
		}
	}

	void update(const Ark_Plugin_File& in_file);
	void update(const Ark_Plugin_File_History& in_history);

	FName get_icon_name() const;
	
	FString relative_path;
	FString absolute_path;
	Ark_Plugin_File file;
	FString lock_owner;
	FDateTime date_time;

	TArray<TSharedRef<FArkSourceControlRevision, ESPMode::ThreadSafe>> revisions;

	FResolveInfo resolve_info;
	
	// ISourceControlState
	virtual int32 GetHistorySize() const override;
	virtual TSharedPtr<class ISourceControlRevision, ESPMode::ThreadSafe> GetHistoryItem(int32 HistoryIndex) const override;
	virtual TSharedPtr<class ISourceControlRevision, ESPMode::ThreadSafe> FindHistoryRevision(int32 RevisionNumber) const override;
	virtual TSharedPtr<class ISourceControlRevision, ESPMode::ThreadSafe> FindHistoryRevision(const FString& InRevision) const override;
	virtual TSharedPtr<class ISourceControlRevision, ESPMode::ThreadSafe> GetCurrentRevision() const override;
	virtual FResolveInfo GetResolveInfo() const override;
#if SOURCE_CONTROL_WITH_SLATE
	virtual FSlateIcon GetIcon() const override;
#endif //SOURCE_CONTROL_WITH_SLATE
	virtual FText GetDisplayName() const override;
	virtual FText GetDisplayTooltip() const override;
	virtual TOptional<FText> GetWarningText() const override;
	virtual const FString& GetFilename() const override;
	virtual const FDateTime& GetTimeStamp() const override;
	virtual bool CanCheckIn() const override;
	virtual bool CanCheckout() const override;
	virtual bool IsCheckedOut() const override;
	virtual bool IsCheckedOutOther(FString* Who = nullptr) const override;
	virtual bool IsCheckedOutInOtherBranch(const FString& CurrentBranch = FString()) const override { return false;  }
	virtual bool IsModifiedInOtherBranch(const FString& CurrentBranch = FString()) const override { return false; }
	virtual bool IsCheckedOutOrModifiedInOtherBranch(const FString& CurrentBranch = FString()) const override { return IsCheckedOutInOtherBranch(CurrentBranch) || IsModifiedInOtherBranch(CurrentBranch); }
	virtual TArray<FString> GetCheckedOutBranches() const override { return TArray<FString>(); }
	virtual FString GetOtherUserBranchCheckedOuts() const override { return FString(); }
	virtual bool GetOtherBranchHeadModification(FString& HeadBranchOut, FString& ActionOut, int32& HeadChangeListOut) const override { return false; }
	virtual bool IsCurrent() const override;
	virtual bool IsSourceControlled() const override;
	virtual bool IsAdded() const override;
	virtual bool IsDeleted() const override;
	virtual bool IsIgnored() const override;
	virtual bool CanEdit() const override;
	virtual bool IsUnknown() const override;
	virtual bool IsModified() const override;
	virtual bool CanAdd() const override;
	virtual bool CanDelete() const override;
	virtual bool IsConflicted() const override;
	virtual bool CanRevert() const override;

};
