﻿#pragma once

#include "ISourceControlChangelistState.h"
#include "FArkSourceControlChangelist.h"

struct Ark_Plugin_Ws_Cl;

class FArkSourceControlChangelistState : public ISourceControlChangelistState
{
public:
	FArkSourceControlChangelistState(const FArkSourceControlChangelist in_changelist)
		:changelist(in_changelist)
	{
	}

	void update(const Ark_Plugin_Ws_Cl& plugin_ws_cl);
	
	FArkSourceControlChangelist changelist;

	FString comment;

	FDateTime timestamp;
	
	TArray<FSourceControlStateRef> files_states;
	// @todo To be supported at a later time
	TArray<FSourceControlStateRef> shelved_files_states;

	// ISourceControlChangelistState
	virtual FName GetIconName() const override { return FName("SourceControl.Changelist"); }
	virtual FName GetSmallIconName() const override { return FName("SourceControl.Changelist"); }
	virtual FText GetDisplayText() const override { return FText(); }
	virtual FText GetDescriptionText() const override { return FText::FromString(comment); }
	virtual bool SupportsPersistentDescription() const override { return true; }
	virtual FText GetDisplayTooltip() const override { return FText(); }
	virtual const FDateTime& GetTimeStamp() const override { return timestamp; } // @todo
	virtual const TArray<FSourceControlStateRef> GetFilesStates() const override { return files_states; }
	virtual int32 GetFilesStatesNum() const override { return files_states.Num(); }
	virtual const TArray<FSourceControlStateRef> GetShelvedFilesStates() const override { return shelved_files_states; }
	virtual int32 GetShelvedFilesStatesNum() const override {return shelved_files_states.Num(); }
	virtual FSourceControlChangelistRef GetChangelist() const override;
	// ~ISourceControlChangelistState
};
