# What is Ark?

Ark is a centralized versioning control system, specially focused on game development, but can be used for any kind of development.

For an extensive list of what it is and how it differs from other versioning control system, please check https://ark-vcs.com.

Thank you for taking the time to look at Ark!


# Getting Started

Ark is a self-contained executable, so you can just drop it wherever you want.

In this executable you have:
	- Server
	- Client Application
	- Command-Line Interface

## Server

To run the server, create an empty folder where you want the root of this server to be. This is the place where the server will store everything.

To initialize and run the server, open the terminal, go to this new folder and execute in the terminal the following command
	ark server -r ./

## Client Application

There's 2 ways to launch Ark as a client application:
	- Double click ark executable
	- Run ark gui

Since version 0.2.0, there's an option to create Workspaces with built-in servers. This means that when you open the client application, those servers get launched automatically for you.

Please check https://ark-vcs.com/documentation.html for more detailed information about how to use the client application.


## Command-Line Interface

Currently the CLI version is quite limited, as it hasn't been the focus of the development.

In order to see the commands supported, run
	ark help

Here's the most important ones:
	ark init
	ark get-latest
	ark server

## Where does Ark save data?

Data is stored in the following places:
	- Directory where you initialize the server
	- .ark/ inside the directory where you initialize a client workspace
	- C:/Users/{user}/AppData/Local/Ark-Vcs/ for everything else (e.g. preferences)


# What's Next?

There's still quite some things that need to be worked on before Ark can be used in production, however this version is being released so that you can evaluate how the project looks and if you're interested in supporting it to accelerate its development.

If you're interested in supporting this project please go to https://ark-vcs.com/order.html.

For more information about the roadmap please check https://ark-vcs.com/roadmap.html.

If you have any questions feel free to get in touch via info@ark-vcs.com or https://twitter.com/nafonsopt.
